/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : platform_config.h
* Author             : MCD Application Team
* Version            : V2.0.1
* Date               : 06/13/2008
* Description        : Evaluation board specific configuration file.
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __PLATFORM_CONFIG_H
#define __PLATFORM_CONFIG_H

/* Includes ------------------------------------------------------------------*/
/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Uncomment the line corresponding to the STMicroelectronics evaluation board
   used to run the example */

#if !defined (USE_STM3210B_EVAL)
 #define USE_STM3210B_EVAL
#endif

/* Define For ET-STM32F103 Board */
#ifdef USE_STM3210B_EVAL

  // Define LCD-NOKIA5110 PinIO Interface Mask Bit 
  #define  LCD5110_SCE_PIN 		       GPIO_Pin_8			// SCE = PB[8]
  #define  LCD5110_SCE_PORT		       GPIOB
  #define  RCC_APB2Periph_GPIO_SCE     RCC_APB2Periph_GPIOB

  #define  LCD5110_RES_PIN		       GPIO_Pin_9			// RES = PB[9]
  #define  LCD5110_RES_PORT		       GPIOB
  #define  RCC_APB2Periph_GPIO_RES     RCC_APB2Periph_GPIOB

  #define  LCD5110_DC_PIN		       GPIO_Pin_10			// DC = PB[10]
  #define  LCD5110_DC_PORT	           GPIOB
  #define  RCC_APB2Periph_GPIO_DC      RCC_APB2Periph_GPIOB

  #define  LCD5110_LED_PIN	           GPIO_Pin_11			// LED = PB[11]
  #define  LCD5110_LED_PORT	           GPIOB
  #define  RCC_APB2Periph_GPIO_LED     RCC_APB2Periph_GPIOB

  #define  LCD5110_SCE_HI()    	       GPIO_WriteBit(LCD5110_SCE_PORT,LCD5110_SCE_PIN,Bit_SET)
  #define  LCD5110_SCE_LO()		       GPIO_WriteBit(LCD5110_SCE_PORT,LCD5110_SCE_PIN,Bit_RESET)

  #define  LCD5110_RES_HI()    	       GPIO_WriteBit(LCD5110_RES_PORT,LCD5110_RES_PIN,Bit_SET)  
  #define  LCD5110_RES_LO() 		   GPIO_WriteBit(LCD5110_RES_PORT,LCD5110_RES_PIN,Bit_RESET)

  #define  LCD5110_DC_HI() 	           GPIO_WriteBit(LCD5110_DC_PORT,LCD5110_DC_PIN,Bit_SET)
  #define  LCD5110_DC_LO() 	           GPIO_WriteBit(LCD5110_DC_PORT,LCD5110_DC_PIN,Bit_RESET)
   
  #define  LCD5110_LED_HI() 	       GPIO_WriteBit(LCD5110_LED_PORT,LCD5110_LED_PIN,Bit_SET)
  #define  LCD5110_LED_LO()	           GPIO_WriteBit(LCD5110_LED_PORT,LCD5110_LED_PIN,Bit_RESET)
  
#endif /* USE_STM3210B_EVAL */

/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

#endif /* __PLATFORM_CONFIG_H */

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
